# Builder Template Categories

**General Info**

* [Plugin page on WordPress.org: wordpress.org/plugins/builder-template-categories/](https://wordpress.org/plugins/builder-template-categories/)
* [Translate the plugin](https://translate.wordpress.org/projects/wp-plugins/builder-template-categories)
* [**Join plugin's newsletter for insider info, tutorials and more**](https://eepurl.com/gbAUUn)
* [**Become a Patron**](https://www.patreon.com/deckerweb) and support ongoing development, maintenance and support of this plugin
* [**Donate** for the further development & support of the plugin](https://www.paypal.me/deckerweb)
* [Plugin's documentation & FAQ](https://wordpress.org/plugins/builder-template-categories/#faq)
* [Facebook Community User Group](https://www.facebook.com/groups/deckerweb.wordpress.plugins/)
* [Facebook Info Page for Deckerweb Plugins](https://www.facebook.com/deckerweb.wordpress.plugins/)


## Changelog of the Plugin

### 🎉 1.7.0 - 2019-09-23

* New: Extended integration with plugin JetEngine (Premium, by Zemez Jet/ CrocoBlock) for Form Categories
* New: Added integration with plugin ToolKit for Elementor (Premium, by ToolKit for Elementor)
* New: Added integration with theme Woostify - Header & Footers via Woostify Pro Add-On plugin (Premium, by BoostifyThemes)
* New: Added integration with plugin Woody Snippets (formerly: Insert PHP) (free, by Webcraftic)
* New: Added integration with plugin ElementsKit Lite/Pro (free/Premium, by wpmet)
* New: Added integration with plugin Flo Forms (free, by Flothemes)
* New: Added integration with plugin Boxzilla (free, by ibericode)
* New: Added integration with plugin Holler Box (free, by Scott Bolinger)
* New: Added integration with theme Neve - Neve Custom Layouts via Neve Pro Add-On plugin (Premium, by ThemeIsle)
* New: Added new template content types "URL/ URLs" and "Redirect/ Redirects"
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.5.0) - better performance due to the use of transients
* Tweak: Minor code improvements
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### 🎉 1.6.0 - 2019-08-16

* New: Added integration with plugin GiveWP Donations (free, by GiveWP/ Impress.org, LLC)
* New: Added integration with plugin Lightweight Sidebar Manager (free, by Brainstorm Force)
* New: Added integration with plugin Reusable Layouts for SiteOrigin (free, by Echelon)
* New: Added integration with plugin Reusable Blocks - Elementor, Beaver Builder, WYSIWYG (free, by WebEmpire)
* New: Added integration with plugin Block Areas (free, by The WP Rig Contributors)
* New: Added integration with plugin HT Script (Insert Headers and Footers Code) (free, by HasThemes)
* New: Added integration with plugin HappyForms (free) and HappyForms Pro (Premium) (both by The Theme Foundry)
* New: Added integration with plugin Beaver Builder (Premium, by The Beaver Builder Team) -- the pro version
* New: Added integration with plugin Beaver Themer (Premium, by The Beaver Builder Team)
* New: Added integration with plugin Divi Builder (Premium, by Elegant Themes)
* New: Added integration with theme Divi (Premium, by Elegant Themes)
* New: Added integration with theme Extra (Premium, by Elegant Themes)
* New: Added new template content types "Sidebar/ Sidebars", "Area/ Areas", "Form/ Forms" and "Script/ Scripts"
* Tweak: Corrected some labels for their singular/plural form
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.4.1) - feature updates
* Tweak: Minor code improvements
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### ⚡ 1.5.1 - 2019-05-03

* *New: Successfully tested with WordPress 5.2*
* *New: Successfully tested with ClassicPress 1.0.1*
* New: Integrated with WordPress 5.2+ new Site Health feature: Builder Template Categories now has an extra section on the Debug Info tab - this is especially helpful for support requests
* Tweak: Refined integration and compatibility with Toolbar Extras v1.4.3 or higher, regarding the Block Editor support
* Tweak: Refined recommended Gutenberg-specific plugins for "Plugin Installer Recommendations" library
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.4.0) - feature updates
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs


### 🎉 1.5.0 - 2019-03-28

* New: Added integration with theme Page Builder Framework - Custom Sections via WPBF Premium Add-On plugin (Premium, by David Vongries & MapSteps)
* New: Added integration with theme Suki - Custom Blocks via Suki Pro Add-On plugin (Premium, by SukiWP/ David Rozando)
* New: Added integration with theme Customify - Customify Hooks via Customify Pro Add-On plugin (Premium, by WPCustomify/ PressMaximum)
* New: Added integration with plugin CartFlows (free, by CartFlows Inc.)
* New: Added additional integration with plugin Oxygen Builder - Oxygen User Elements Library (*if enabled via Library settings in Oxygen v2.3 alpha 1 or higher*)
* *New: Successfully tested with WordPress 5.1.1*
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.3.0) - feature updates
* Tweak: Minor code improvements
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here


### 1.4.3 - 2019-01-21

* New: Additional checks for Block Editor (Gutenberg) integration if one of the popular disabling plugins has disabled it completely (in that case the integration won't be loaded at all!)
* New: Overhauled Elementor integration to be also fully compatible with Elementor 2.4.0 or higher (while still being compatible with older Elementor versions)
* New: Make predefined category terms also available for Elementor built-in "Categories" taxonomy (only for Elementor v2.4.0+)
* New: Added new template content types "Flow/ Flows" and "Snippet/ Snippets"
* New: [Join my newsletter for DECKERWEB WordPress Plugins](https://eepurl.com/gbAUUn) - insider info, plus tutorials and more useful stuff
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here - also added new FAQ entry


### 1.4.2 - 2018-12-14

* Tweak: Moved admin CSS into proper stylesheet, and enqueue it - this fixes issues users have reported


### 1.4.1 - 2018-12-13

* New: Successfully tested with WordPress 5.0.x major release version
* New: Added new template content type "Section/ Sections"
* Tweak: Make sure our help tab is restricted to our own taxonomy only
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.1) - CSS fixes
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here


### 1.4.0 - 2018-11-21

* New: Integration with plugin Epic News Elements (Premium, by Jegtheme) - *an Add-On for Elementor, Block Editor (Gutenberg) and WPBakery Page Builder (old Visual Composer)*
* New: Integration with plugin Master Popups (Premium, by CodexHelp)
* New: Integration with plugin Block Lab (free, by Block Lab) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin Gutenberg Templates (Block Templates) (free, by Konstantinos Galanakis) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin Visual Composer Website Builder (free/Premium, by The Visual Composer Team) -- Note: this is the new plugin version from 2018, not the old one (now renamed), "WPBakery Page Builder"
* New: Integration with Page Builder plugin Avada Fusion Builder in *Avada Theme* (Premium, by ThemeFusion)
* New: Integration with plugin Smart Footer System (Premium, by Meta Plugin) - compatible with Elementor, Gutenberg, Genesis, Beaver Builder etc.
* New: Integration with plugin Easy Content Templates (free, by Japa Alekhin Llemos)
* New: Integration with plugin Simple Content Templates (free, by Clifton Griffin)
* New: Integration with plugin Custom Page Templates (Premium, by Pavlo Reva)
* New: Added integration with "Elementor Finder" - interactive search since Elementor v2.3.0+
* Tweak: For some integrations (manually) added taxonomy column to the post type list table (overview table) where the automatic adding didn't work (because of customized post types...)
* Tweak: Set proper 'parent file' / 'subemenu file' relations for all integrations - therefore our taxonomy is now highlighted correctly as submenu in the Admin
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here


### 1.3.0 - 2018-10-30

* New: Integration with plugin Advanced Custom Fields (ACF) (free & Pro, by Elliot Condon)
* New: Integration with plugin Custom Field Suite (free, by Matt Gibbs)
* New: Integration with Add-On plugin CMB2 Admin Extension (free, by twoelevenjay) --> Note: This is the UI plugin for the [CMB2 library](https://wordpress.org/plugins/cmb2/) plugin!
* New: Integration with Add-On plugins Meta Box Builder and Meta Box All-In-One (AIO) (both Premium, by Meta Box) --> Note: This is the UI plugin for the [Meta Box](https://wordpress.org/plugins/meta-box/) (fields) plugin!
* New: Integration with plugin Custom Template for LifterLMS (free, by Brainstorm Force)
* New: Integration with plugin Custom Template for LearnDash (free, by Brainstorm Force)
* New: Integration with plugin Opal Widgets for Elementor (free, by WpOpal) - for Header and Footer templates
* New: Integration with plugin Reusable Content Blocks (free, by Safeer)
* New: Integration with plugin JetSmartFilters (Premium, by Zemez Jet/ CrocoBlock)
* New: Added new template content type "Filter/ Filters"
* New: Added 2 new screenshots to show Reusable Block support in Block Editor (Gutenberg)
* New: Successfully tested with WordPress 5.0 Beta 1
* New: [Video of plugin walkthrough and live demo](https://www.youtube.com/watch?v=9FhIJ2QxOoQ)
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.2.0) - which brings enhanced CSS styles, including for the "Dark Mode" plugin
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here - also added some new FAQ entries


### 1.2.0 - 2018-10-12

* *The Gutenberg Block Editor Support Release ;-)*
* New: Integration with "Gutenberg plugin" / (upcoming) WordPress Version 5.0+: Block categories for new default `wp_block` post type, plus admin enhancements - this lets you manage the "reusable blocks" feature better
* New: Integration with plugin Lazy Blocks (free, by nK) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin Advanced Custom Blocks (free, by Rheinard Korf, Luke Carbis, Rob Stinson) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin Blocks Layouts (free, by Jordy Meow) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin Square Happiness: Placeholder Block (free, by Square Happiness) -- *for WordPress Block Editor, also known as "Gutenberg"*
* New: Integration with plugin StylePress for Elementor (free, by David Baker (dtbaker))
* New: Integration with plugin Content Blocks (Custom Post Widget) (free, by Johan van der Wijk)
* New: Integration with plugin Reusable Content & Text Blocks (free, by Loomisoft)
* New: Integration with plugin Dev Content Blocks (free, by Allon Sacks)
* New: Integration with plugin Text Blocks (free, by Hal Gatewood)
* New: Integration with plugin Widget Content Blocks (free, by Danny van Kooten)
* New: Added new template content types "Field/ Fields", "Box/ Boxes", "Bar/ Bars" and "Hook/ Hooks"
* New: If Fields, Box, Bar or Hook template related integrations are active before plugin installation/activation add predefined terms for "Fields", "Boxes", "Bars" and "Hooks" appropriately
* New: [Facebook Info Page for my WordPress plugins](https://www.facebook.com/deckerweb.wordpress.plugins/), this one included :)
* Tweak: Code, plus code documentation improvements and tweaks
* Tweak: Improved special "translators" comments in code
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here


### 1.1.0 - 2018-09-30

* New: Category labels now fit to the content type (post type) of the integration - popup integrations are now labelled as "Popup Categories", and the same for other types like Blocks, Layouts, Elements etc.
* New: Integration with Page Builder plugin Themify Builder (Premium, by Themify) - note: this applies only to the premium version of this plugin
* New: Integration with plugin JetPopup (free, by Zemez Jet/ CrocoBlock)
* New: Integration with plugin Cherry PopUps (free, by Zemez)
* New: Integration with plugin Templementor (free, by Lcweb)
* New: Integration with plugin Kadence WooCommerce Elementor (free, by Kadence Themes) - for single product templates
* New: Integration with plugin Kadence WooCommerce Elementor Pro (Premium, by Kadence Themes) - for product archive templates and checkout templates
* New: Integration with plugin Themify Popup (free, by Themify)
* New: Integration with Add-On plugins Meta Box Post Types and Meta Box Taxonomy (both free, by Meta Box)
* New: If WooCommerce template related integrations are active before plugin installation/activation add predefined "Products" term
* New: If Popup/Modal template related integrations are active before plugin installation/activation add predefined "Popups" term
* New: In post type list tables for bulk actions the "Edit" label was tweaked to "Edit, add Category etc." to make it more clear for users that template categories (of this plugin) can be added as well in bulk mode
* New: Added help tab with additional info - appearing on the plugin's taxonomy page as well as all edit screens from post types of any active integration
* New: Added a new screenshot to show Bulk Actions - to add template category to more than one template in one action
* New: Created special [Facebook Group for user community support](https://www.facebook.com/groups/deckerweb.wordpress.plugins/) for all plugins from me (David Decker - DECKERWEB), this one here included! ;-) - [please join at facebook!](https://www.facebook.com/groups/deckerweb.wordpress.plugins/)
* Tweak: Partly refactored the WPBakery Page Builder integration - now by default the Grid Builder Templates are integrated, and optionally, if the Templatera templates are active (premium Add-On), these as well -- that way, all makes more sense
* Tweak: Smaller code and inline documentation tweaks, plus improvements
* Tweak: Updated bundled library DDWlib Plugin Installer Recommendations to latest version (v1.1.0) - which brings smaller additions and enhancements, like CSS styles to the upload areas and plugin cards, plus plugin version number on plugin cards
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced and improved Readme.txt file here - also added new FAQ entry


### 1.0.1 - 2018-08-30

* New: Integration with Brizy Templates for Brizy Page Builder - template feature was released in their free version v1.0.25
* New: Added plugin update message also to Plugins page (overview table)
* New: French translations by the community
* Tweak: Added plugins recommendations library by deckerweb to improve the plugin installer tips (old filter function got removed)
* Tweak: Updated `.pot` file plus all German translations (formal, informal) and language packs
* Tweak: Enhanced, improved and corrected Readme.txt file here - also tweaked FAQ entry


### 1.0.0 - 2018-08-20

* *Official plugin launch on WordPress.org. Everything's new!*
* New: Including integration for 15 Plugins: Elementor, AnyWhere Elementor, Header Footer for Elementor, Popup Maker, PopBox for Elementor, Thrive Lightboxes, Oxygen Builder (2.0+), Pods, JetEngine for Elementor, JetWooBuilder for Elementor, DHWC Elementor (WooCommerce Templates), WP Show Posts, BoldGrid Post and Page Builder, WPBakery Page Builder (Visual Composer), Global Blocks for Cornerstone
* New: Including integration for 5 Themes: OceanWP, GeneratePress, Astra, Kava Pro (CrocoBlock), Genesis (Blox)
* New: Includes a `composer.json` file in the plugin's root folder - this is great for developers using Composer


### 0.9.1 - 2018-08-17

* New: Added [Code Snippets](https://github.com/deckerweb/builder-template-categories/wiki/Code-Snippets) as GitHub Gists
* New: Added [short and easy "documentation" as Wiki](https://github.com/deckerweb/builder-template-categories/wiki) in official GitHub repository for the plugin
* New: Added integration "WPBakery Page Builder" (the old Visual Composer), via its "Templatera" Add-On plugin


### 0.9.0 - 2018-08-16

* New: Beta release of the plugin on [its public GitHub repository](https://github.com/deckerweb/builder-template-categories)
